function setHybridParams(bv)
%SETHYBRIDPARAMS Modify parameters for a greenhouse crop model based on Vanthoor (2011), according to a dataset with a hybrid lighting system
% Note that this has not been fully calibrated yet, so still a work in progress.
% Inputs:
%   bv   - a StateSpaceModel object to be used as a Vanthoor model
%
% Based on:
%   Dueck, T., De Gelder, A., Janse, J., Baar, P. H., Eveleens, B., 
%   Grootscholten, M. (2013). Het Nieuwe Belichten bij tomaat met minder CO2. 
%   Retrieved from http://library.wur.nl/WebQuery/wurpubs/fulltext/255155

% David Katzin, Wageningen University
% david.katzin@wur.nl

	setParam(bv, 'psi', 23); 					% Mean greenhouse cover slope 																	 						25 [1]
    setParam(bv, 'aFlr', 1008);                 % Floor area of greenhouse 																		m^{2} 					1.4e4 [1]          
    setParam(bv, 'aCov', 1.4*1008);             % Surface of the cover including side walls 													m^{2} 					1.8e4 [1]
    setParam(bv, 'hAir', 6.7);                  % Height of the main compartment 																m 						3.8 [1]
    setParam(bv, 'hGh', 7.2);                   % Mean height of the greenhouse 																m 						4.2 [1] 

    
    setParam(bv, 'aRoof', 118.8);               % Maximum roof ventilation area 																- 						0.1*aFlr [1]
    setParam(bv, 'hVent', 0.7);                 % Vertical dimension of single ventilation opening 												m 						0.68 [1]
    setParam(bv, 'cLeakage', 1.4e-4); 			% Leakage coefficient 																			- 						1e-4 [1]
    
    setParam(bv, 'tauThScrPar', 0.85); 			% PAR transmission coefficient of thermal screen 												- 						0.6 [1]
    
    setParam(bv, 'phiPipeI', (51e-3)-(2.25e-3));% Internal diameter of pipes 																	m 						47e-3 [1]
    setParam(bv, 'lPipe', 1.25);            % Personal communication Arjan Vervoot, Feije de Zwart, Frank Kempkes, Arie de Gelder
    setParam(bv, 'pBoil', 44*bv.p.aFlr.val);    % Capacity of the heating system                                                                W                       88*p.aFlr (Assumed to be 88 W m^{-2}) [5]
    setParam(bv, 'phiExtCo2', 720);             % Capacity of external CO2 source 																mg s^{-1} 				7.2e4 [1] (for 1.4e4 m^{2}) 2.778 mg s^{-1} m^{-2} [5]
	
    setParam(bv, 'epsGroPipe', 0.88);              % Emissivity of grow pipes                                                                  [-]                                     0 (no grow pipes)
    setParam(bv, 'lGroPipe', 1.25); % Thesis Arjan Vervoort, based on talks with Feije de Zwart, Frank Kempkes, Arie de Gelder
    setParam(bv, 'phiGroPipeE', 28e-3);
    setParam(bv, 'phiGroPipeI', (28e-3)-(1.2e-3));
    setParam(bv, 'pGroBoil', 44*bv.p.aFlr.val); % Capacity of the grow pipe heating system                                                      W                                       88*p.aFlr (Assumed to be same as pipe rail, but actually based on [5] pBoil+pGroBoil should be 88) 
    
    %% Lamp parameters
    
    % HPS toplights
    setParam(bv, 'lampsMax', 64.7);             	% assume 1.7 efficiency at 110umol/m2/s% Maximum intensity of lamps                             [W m^{-2}]                              100 [5]
    setParam(bv, 'heatCorrection', 0);   			% correction for temperature setpoint when lamps are on 										[C]   									0
    setParam(bv, 'etaLampPar', 0.39);  			% fraction of lamp input converted to PAR 														[-]                                     0.4 [calculated from 5]
    setParam(bv, 'etaLampNir', 0.22);  			% fraction of lamp input converted to NIR 														[-]                                     0.2 [7]   
    setParam(bv, 'tauLampPar', 0.9825);           % transmissivity of lamp layer to PAR 															[-]                                     0.9825 [7]
    setParam(bv, 'rhoLampPar', 0.0025);           % reflectivity of lamp layer to PAR 															[-]                                     0 [7]
    setParam(bv, 'tauLampNir', 0.9825);           % transmissivity of lamp layer to NIR 															[-]                                     0.9825 [7]
    setParam(bv, 'rhoLampNir', 0);                % reflectivity of lamp layer to NIR 															[-]                                     0 [7]
    setParam(bv, 'tauLampFir', 0.9825);           % transmissivity of lamp layer to FIR 															[-]                                     0.9825 (assumed)
    setParam(bv, 'aLamp', 0.015);                 % lamp area 																					[m^{2}{lamp} m^{-2}{floor}]             0.02 [7]
    setParam(bv, 'epsLampTop', 0.5);              % emissivity of top side of lamp 																[-]                                     0.02 (calibrated)
    setParam(bv, 'epsLampBottom', 0.9);           % emissivity of bottom side of lamp 															[-]                                     0.2 (calibrated)
    setParam(bv, 'capLamp', 350);                 % heat capacity of lamp 																		[J K^{-1} m^{-2}]                       115 (calculated)
    setParam(bv, 'hecLampAir', 0.0429);           % heat exchange coefficient of lamp                                                             [W m^{-2} K^{-1}]                       0.0429 (calculated)
    setParam(bv, 'lampCool', 0);                  % fraction of lamp input removed by cooling

    % LED Interlight parameters 
    setParam(bv, 'capIntLamp', bv.p.capGroPipe.val);          % heat capacity of lamp 															[J K^{-1} m^{-2}]                       Assumed to be same as grow pipes
    setParam(bv, 'etaIntLampPar', 0.38);          % fraction of lamp input converted to PAR 														[-]                                     Based on 0.5*(1.6+1.91) umol/J and 4.6 umol/J in PAR
    setParam(bv, 'etaIntLampNir', 0);             % fraction of lamp input converted to NIR 														[-]                                     0 [7]   
    setParam(bv, 'aIntLamp', 0.3);                % interlight lamp area 																			[m^{2}{lamp} m^{-2}{floor}]             current specifications (philips website): 2.5x2x(0.065+0.079)=0.72m2/lamp; 80 W/lamp;  0.71225 lamps/m2
                                                                                                                                                                                        % lamps I checked: 2.5x2x(0.05+0.03)=0.4, don't know the wattage but can check (assume 80?)                                   
    setParam(bv, 'epsIntLamp', bv.p.epsPipe.val); % emissivity of interlight [-]                                                                  assumed that lamps act the same as heating pipes
    setParam(bv, 'intLampsMax', 56.98);           % Maximum intensity of lamps																	[W m^{-2}]                              56.98
    setParam(bv, 'hecLampAir', 2.3);              % heat exchange coefficient of lamp                                                             [W m^{-2} K^{-1}]

    setParam(bv, 'leakTop', 0.9);                 % Fraction of leakage ventilation going from the top                                            [-]                                     0.5 [1]
    
    % Reset other parameters that may depend on parameters changed above
    setDepParams(bv);  

end

